sink("steenbergen-jones-lme4-multiparameter-test.Rlog",split=TRUE)
load("steenbergen-jones-data.RData")

# Steenbergen and Jones example:
# Dependent variable is 
# 'support': the support for EU
# Independent variables are
# at country level:
#   'tenurez': Tenure within EU (standardized)
#   'tradez':  Within-EU trade (standardized)
#   'gdpz':    GDP per capita (standardized)
#   'inflz':   Inflation (standardized)
# at individual level
#   'inclow':  Dummy for lowest income quartile
#   'inchi':   Dummy for highest income quartile
#   'lright':  Left-right self-placement
#   'opinion leadership': (centered)
#   'male': Male gender dummy
#   'age': Age


## Users may need to install the packages 'lme4', 'lmerTest', 'pbkrtest'
## before running the followin lines, e.g. with
# install.packages(c("devtools","lmerTest","pbkrtest"))

library(lme4)
library(lmerTest)
# Note that lmer() now is modified by "lmerTest"
sj4LT.reml <- lmer(support ~ tenurez + tradez + gdpz + inflz
                         + inclow + inchi + lright + olead + male + age
                         + (1|country),
             data = steenbergen_jones_data)
# First construct a matrix for contrasts to be tested
test.matrix <- function(model,test_these){
    cf <- fixef(model)
    cfn <- names(cf)
    L <- diag(nrow=length(cf))
    colnames(L) <- rownames(L) <- cfn
    L[test_these,]
}
macro.test.matrix <- test.matrix(sj4LT.reml,
                                 c("tenurez","tradez","gdpz","inflz"))
# 'contest() conducts a multi-parameter Wald test
# an F-distribution where the denominator degrees
# of freedom are determined by the Satterthwaite method
contest(sj4LT.reml,
        L = macro.test.matrix)

library(pbkrtest)
# For using the Kenward-Roger method we need a "null" model,
# the same set of observations:
sj4LT.reml.0 <- update(sj4LT.reml,
                       .~.-(tenurez + tradez + gdpz + inflz),
                       subset=is.finite(tenurez + tradez + gdpz + inflz))
# and then compare the "full" and the "null" model:
KRmodcomp(sj4LT.reml, sj4LT.reml.0)
sink()

