\name{Wald}
\alias{Wald}
\title{Formula Based Wald Tests}
\description{
  \code{Wald} performs tests about linear hypotheses
  with respect to coefficient estimates of (generalized)
  linear models.
}
\usage{
Wald(x, model, R=NULL, q=NULL)
}
\arguments{
  \item{x}{a formula or a list of formulas.
    }
  \item{model}{a model object, for which \code{\link[stats]{coef}}
    and \code{\link[stats]{vcov}} methods exist; or in case
    of the "list" method, also a list of such model objects.
  }
  \item{R}{an optional numeric matrix giving the contrasts to be tested
    or a list of such model matrices.
  }
  \item{q}{a optional numeric vector or a list of vectors.
  }
}
\details{
  This function performs a test of the linear hypothesis
  \deqn{R\beta=q,}{R*beta=q,}
  where \eqn{beta}{beta} is the subvector of the coefficients selected
  by the formula(s in) \code{x}.
  It computes the Wald statistic
  \deqn{
    W=(R\beta-q)'(RVR')^{-1}(R\beta-q)
  }{W=(R*beta-q)'(R*V*R')^(-1)(R*beta-q)}
  and p-values under the assumption of a Chi-squared distribution of \eqn{W}{W},
  with degrees-of-freedom equal to the rank of \eqn{RVR'}{R*V*R'}.
  If this matrix is not of full rank, then a generalized inverse is used for
  computing \eqn{W}{W}.
}
\value{
  An object of class "Wald", for which a \code{print} method is defined.
}
\seealso{
  \code{\link[car]{linear.hypothesis}},
  \code{\link[lmtest]{waldtest}}
}
\examples{
berkeley <- aggregate(wtable(Admit,Freq)~.,data=UCBAdmissions)

# Test whether the effect of gender varies
# across departments - variant 1
summary(berkeley.model1 <- glm(cbind(Admitted,Rejected)~Dept*Gender,
    family = "binomial",
    data = berkeley))
Wald(~Dept:Gender,berkeley.model1)

# Test whether the effect of gender varies
# across departments variant - 2
summary(berkeley.model2 <- glm(cbind(Admitted,Rejected)~Dept/Gender-1,
    family = "binomial",
    data = berkeley))

Wald(~Dept:Gender,berkeley.model2,
  R = rbind(# Test all contrasts simultaneously
    c(1, -1/5,-1/5,-1/5,-1/5,-1/5),
    c(-1/5, 1, -1/5,-1/5,-1/5,-1/5),
    c(-1/5,-1/5, 1, -1/5,-1/5,-1/5),
    c(-1/5,-1/5,-1/5, 1, -1/5,-1/5),
    c(-1/5,-1/5,-1/5,-1/5, 1, -1/5),
    c(-1/5,-1/5,-1/5,-1/5,-1/5, 1)
    )
  )

Wald(~Dept:Gender,berkeley.model2,
  R = list(# Test each contrast separately.
           # Note that such tests are anti-
           # conservative.
    A=c(1, -1/5,-1/5,-1/5,-1/5,-1/5),
    B=c(-1/5, 1, -1/5,-1/5,-1/5,-1/5),
    C=c(-1/5,-1/5, 1, -1/5,-1/5,-1/5),
    D=c(-1/5,-1/5,-1/5, 1, -1/5,-1/5),
    E=c(-1/5,-1/5,-1/5,-1/5, 1, -1/5),
    F=c(-1/5,-1/5,-1/5,-1/5,-1/5, 1)
    )
  )

# Third variant: Likelihood ratio test.
anova(glm(cbind(Admitted,Rejected)~Dept+Gender,
    family = "binomial",
    data = berkeley),
    glm(cbind(Admitted,Rejected)~Dept*Gender,
    family = "binomial",
    data = berkeley),
    test="Chisq")

}
\keyword{programming}