\name{Dummies}
\alias{Dummies}
\alias{Dummies.default}
\alias{Dummies.factor}
\alias{Dummies.labelled}
\title{Create a Matrix of Zero-One Data}
\description{
  The generic function \code{Dummies} and its methods
  create a matrix of "dummy variables", it is usued internally
  by \code{\link{mlogit}}, but may otherwise be usefull.

  For the \code{factor} method, each column corresponds to
  a level of the factor and each row corresponds to an observation
  on the factor. For the \code{labelled} method, each column corresponds
  to a value label or unique value of a labelled vector. For the
  default method, each column corresponds to a unique value of the
  vector given as first argument.
}
\usage{
Dummies(x,...)
\method{Dummies}{default}(x,...)
\method{Dummies}{factor}(x,...)
\S4method{Dummies}{item.vector}(x,labelled.only=TRUE,...)
}
\arguments{
  \item{x}{a numeric vector, factor, or labelled vector.}
  \item{labelled.only}{logical value, if TRUE only
    labelled values are considered for the construction of
    the dummy matrix.}
  \item{\dots}{further arguments, ignored.}
}
\details{
  The \code{item} method ignores pre-defined missing values
  of the labelled vector.
}
\seealso{\code{\link[stats]{model.matrix}}.}
\examples{
f <- factor(sample(1:3,18,replace=TRUE),labels=c("a","b","c"))
Dummies(f)
cbind(Dummies(f),f)

f <- as.item(sample(c(1:3,18,9),8,replace=TRUE),
              labels=c(a=1,b=2,c=3,"dk"=8,"na"=9),
              missing.values=c(8,9))
Dummies(f)
cbind(Dummies(f),as.numeric(f),f)
}
\keyword{misc}