rm(list=ls())
library(manifestos)
options(error=recover)

options(latpos.chunk.size=1024*1024)

load("econ-latpos.RData")
load("manifesto-counts.RData")

pred.econ.latpos <- predict(econ.latpos,
                            type="posterior means",
                            interval="percentile",
                            sample.size=1000
                            )

pred.econ.latpos <- as.data.frame(pred.econ.latpos)
names(pred.econ.latpos) <- c("econlr","econlr.lwr","econlr.upr")

pred.econ.latpos <- cbind(pred.econ.latpos,
                            subset(manifesto.counts,
                              select=c(country,
                                       countryname,
                                       edate,
                                       party,
                                       partyname,
                                       rile,
                                       day,
                                       month,
                                       year
                                       ))
                            )
save(pred.econ.latpos,file="predict-econ-latpos.RData")