panel.bands <- function(x,y,groups=NULL,subscripts=NULL,
                            band.col="gray90",
                            band.border.col=NA,
                            band.border.lty=1,...){

  if(!length(groups))
    panel.bands1(x,y,
        band.col=band.col,
        band.border.col=band.border.col,
        band.border.lty=band.border.lty,
        ...)
  else{
    if(length(subscripts))
      groups <- groups[subscripts]
    x <- split(x,groups)
    Y <- matrix(y, nrow = length(y)%/%2, ncol = 2)
    Y <- memisc:::split.matrix(Y,groups)
    band.col <- rep(band.col,len=length(x))
    band.border.col <- rep(band.border.col,len=length(x))
    band.border.lty <- rep(band.border.lty,len=length(x))
    
    for(g in seq_along(x)){
      panel.bands1(x[[g]],Y[[g]],
        band.col=band.col[g],
        band.border.col=band.border.col[g],
        band.border.lty=band.border.lty[g],
        ...)
    }
  }
}

panel.bands1 <- function(x,y,band.col,
          band.border.col,
          band.border.lty,
          ...){

  Y <- matrix(y, nrow = length(y)%/%2, ncol = 2)
  y1 <- Y[,1]
  y2 <- Y[,2]

  x0 <- c(x,rev(x))
  y0 <- c(y1,rev(y2))
  panel.polygon(x0,y0,col=band.col,alpha=.5,border=NA,...)

  if(!is.na(band.border.col)){

    panel.lines(x,y1,col=band.border.col,lty=band.border.lty)
    panel.lines(x,y2,col=band.border.col,lty=band.border.lty)
  }
}
