rm(list=ls())
library(manifestos)
options(error=recover)

options(latpos.chunk.size=1024*1024)

load("econ-latpos.RData")
load("manifesto-counts.RData")
load("sim-econ-latpos.RData")

source("sim-to-pred.R")

updates.sim.latpos  <- function(object,simdata){

  jt.order <- object$jt.order
  orig.order <- object$orig.order

  s0 <- object$resp$s0
  s1 <- object$resp$s1

  sim <- simdata[jt.order,]
  diffs <- array(0,dim=dim(sim))
  diffs[s1,] <- sim[s1,] - sim[s0,]
  diffs[orig.order,]
}

get.jt <- function(object){

  orig.order <- object$orig.order
  j <- object$resp$j
  t <- object$resp$t

  cbind(j,t)[orig.order,]
}

updates.econ.latpos <- updates.sim.latpos(econ.latpos,sim.econ.latpos)
uplo.updates.econ.latpos <- sim.to.pred(econ.latpos,updates.econ.latpos,
                            interval="percentile",level=.90)
uplo.updates.econ.latpos <- as.data.frame(uplo.updates.econ.latpos)
names(uplo.updates.econ.latpos) <- c("econlr","econlr.lwr","econlr.upr")

jt.econ.latpos <- get.jt(econ.latpos)

changes.econ.latpos <- cbind(uplo.updates.econ.latpos,
                            jt.econ.latpos,
                            subset(manifesto.counts,
                              select=c(country,
                                       countryname,
                                       edate,
                                       party,
                                       partyname,
                                       day,
                                       month,
                                       year
                                       ))
                            )
changes.econ.latpos <- subset(changes.econ.latpos,t>0)
save(changes.econ.latpos,file="changes-econ-latpos.RData")
